window = 	{
			w = 0, h = 0, -- this is the current size of the app window
			ref_w = 0, ref_h = 0, -- this is the initial size of the app window, never changes
			} 
canvas = 	{
			w = 0, h = 0, -- w and h is the current viewable render size
			ref_w = 0, ref_h = 0 -- this is the reference screen size, never changes, independent of physical size but maintains aspect ratio
			}

function window.setSize(w,h)
	window.w = w
	window.h = h
	video.setScreenSize(window.w, window.h)
end

function canvas.setSize(w,h)
	canvas.w = w
	canvas.h = h
	video.setRenderScreenSize( canvas.w , canvas.h)
end

function canvas.setToRef()
	if canvas.w ~= canvas.ref_w or canvas.h ~= canvas.ref_h then 
		canvas.setSize(canvas.ref_w, canvas.ref_h)
	end
end

function canvas.setToWindow()
	if canvas.w ~= window.w or canvas.h ~= window.h then 
		canvas.setSize(window.w, window.h)
	end
	canvas.factor = canvas.w/canvas.h
end

function canvas.containsPoint(x,y,buffer)
	return not(x < 0-buffer or x > canvas.w+buffer or y < 0-buffer or y > canvas.h+buffer)	
end

function window.init()
	window.ref_w, window.ref_h = video.getScreenSize()
	window.w, window.h  = window.ref_w, window.ref_h
	canvas.ref_w, canvas.ref_h = window.w, window.h
	canvas.setToWindow()
end